<!DOCTYPE html>
<html>
<head>
	<title>Dynamic Select Menu</title>
	    <!-- BootStrap CSS CDN-->

    <!-- jQuery CDN -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>

    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js"></script>
</head>
<body>
   <div class="container">
      <div>
         <div class="form-group">
            <select onchange="getItemList(this.value)" id="company_list" class="custom-select">
               <option>Select Company</option>
            </select>
         </div>
         <div class="form-group">
            <select onchange="getModelList(this.value)" id="item_list" class="custom-select">
               <option>Select Item</option>
            </select>
         </div>
         
      </div>
   </div>
</body>

<script type="text/javascript">
	$(document).ready(function(){
       
       let tag ="companyList"; 
       let select_menu=$('#company_list')[0]; // this expression is same as document.getElementById('dynamic_menu')
       $.ajax({
            url:"ajax.php",
            dataType:"json",
            method:"post",
            data:{tag:tag},
            success:function(response){
                //alert(response.length);
                console.log($.isArray(response)); // if response is an array, this function will return true

                response.forEach((item,index)=>{
                    console.log(index,item);
                    var option = document.createElement("option");
                    option.value = item['transporter_id'];
                    option.text = item['transporter_name'];
                    select_menu.appendChild(option);
                })
            }
        })
	});
    
    //Getting Item List on the basis of company_id
    function getItemList(company_id)
    {
        let tag = "itemList";
        let itemMenu =$('#item_list')[0];

        //Removing all the old options from item list and model list and adding only one option in one go
        $('#item_list').empty().append('<option>Select Vehicle No.</option>');

        $.ajax({
            url:"ajax.php",
            dataType:"json",
            method:"post",
            data:{tag:tag,company_id:company_id},
            success:function(response){
                response.forEach((item,index)=>{
                    console.log(index,item);
                    var option = document.createElement("option");
                    option.value = item['vehicle_id'];
                    option.text = item['vehicle_no'];
                    itemMenu.appendChild(option);
                })
            }
        })
    }

    //Getting model list on the basis of item id



</script>
</html>